{ *********************************************************************** }
{                                                                         }
{ Translated Header File                                                  }
{ Part of the Delphi Visual Component Library                             }
{                                                                         }
{ Original Header File Copyright (c) 1985-2004 Microsoft Corporation      }
{  All Rights Reserved.                                                   }
{                                                                         }
{ Translation Copyright (c) 1995-2004 Borland Software Corporation        }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.Imm platform;

{$ALIGN 1}
{$MINENUMSIZE 4}

interface

uses
  System.Text, System.Runtime.InteropServices, Windows;

const
  VK_PROCESSKEY = $E5;

type
  HIMC = Integer;

  [StructLayout(LayoutKind.Sequential)]
  tagCOMPOSITIONFORM = record
    dwStyle: DWORD;
    ptCurrentPos: TPOINT;
    rcArea: TRECT;
  end;
  TCompositionForm = tagCOMPOSITIONFORM;
  COMPOSITIONFORM = tagCOMPOSITIONFORM;

  [StructLayout(LayoutKind.Sequential)]
  tagCANDIDATEFORM = record
    dwIndex: DWORD;
    dwStyle: DWORD;
    ptCurrentPos: TPOINT;
    rcArea: TRECT;
  end;
  TCandidateForm = tagCANDIDATEFORM;
  CANDIDATEFORM = tagCANDIDATEFORM;

  [StructLayout(LayoutKind.Sequential)]
  tagCANDIDATELIST = record
    dwSize: DWORD;
    dwStyle: DWORD;
    dwCount: DWORD;
    dwSelection: DWORD;
    dwPageStart: DWORD;
    dwPageSize: DWORD;
    dwOffset: IntPtr; { array[1..1] of DWORD }
  end;
  TCandidateList = tagCANDIDATELIST;
  CANDIDATELIST = tagCANDIDATELIST;

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagREGISTERWORD = record
    [MarshalAs(UnmanagedType.LPTStr)]
    lpReading: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpWord: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagREGISTERWORDA = record
    [MarshalAs(UnmanagedType.LPTStr)]
    lpReading: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpWord: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagREGISTERWORDW = record
    [MarshalAs(UnmanagedType.LPTStr)]
    lpReading: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpWord: string;
  end;
  TRegisterWord = tagREGISTERWORD;
  TRegisterWordA = tagREGISTERWORDA;
  TRegisterWordW = tagREGISTERWORDW;
  REGISTERWORD = tagREGISTERWORD;
  REGISTERWORDA = tagREGISTERWORDA;
  REGISTERWORDW = tagREGISTERWORDW;

const 
  STYLE_DESCRIPTION_SIZE = 32;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagSTYLEBUF = record
    dwStyle: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=STYLE_DESCRIPTION_SIZE)]
    szDescription: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagSTYLEBUFA = record
    dwStyle: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=STYLE_DESCRIPTION_SIZE)]
    szDescription: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagSTYLEBUFW = record
    dwStyle: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=STYLE_DESCRIPTION_SIZE)]
    szDescription: string;
  end;
  TStyleBuf = tagSTYLEBUF;
  TStyleBufA = tagSTYLEBUFA;
  TStyleBufW = tagSTYLEBUFW;
  STYLEBUF = tagSTYLEBUF;
  STYLEBUFA = tagSTYLEBUFA;
  STYLEBUFW = tagSTYLEBUFW;

{ prototype of IMM API }

function ImmInstallIME(lpszIMEFileName, lpszLayoutText: string): HKL;
function ImmInstallIMEA(lpszIMEFileName, lpszLayoutText: string): HKL;
function ImmInstallIMEW(lpszIMEFileName, lpszLayoutText: string): HKL;

function ImmGetDefaultIMEWnd(hWnd: HWND): HWND;

function ImmGetDescription(hKl: HKL; lpTStr: StringBuilder; uBufLen: UINT): UINT;
function ImmGetDescriptionA(hKl: HKL; lpTStr: StringBuilder; uBufLen: UINT): UINT;
function ImmGetDescriptionW(hKl: HKL; lpTStr: StringBuilder; uBufLen: UINT): UINT;

function ImmGetIMEFileName(hKl: HKL; lpTStr: StringBuilder; uBufLen: UINT): UINT;
function ImmGetIMEFileNameA(hKl: HKL; lpTStr: StringBuilder; uBufLen: UINT): UINT;
function ImmGetIMEFileNameW(hKl: HKL; lpTStr: StringBuilder; uBufLen: UINT): UINT; 

function ImmGetProperty(hKl: HKL; dWord: DWORD): DWORD;

function ImmIsIME(hKl: HKL): Boolean;

function ImmSimulateHotKey(hWnd: HWND; dWord: DWORD): Boolean;

function ImmCreateContext: HIMC;
function ImmDestroyContext(hImc: HIMC): Boolean;
function ImmGetContext(hWnd: HWND): HIMC;
function ImmReleaseContext(hWnd: HWND; hImc: HIMC): Boolean;
function ImmAssociateContext(hWnd: HWND; hImc: HIMC): HIMC;

function ImmGetCompositionString(hImc: HIMC; dWord1: DWORD;
  lpBuf: StringBuilder; dwBufLen: DWORD): Longint; overload;
function ImmGetCompositionString(hImc: HIMC; dWord1: DWORD;
  [out] lpBuf: TBytes; dwBufLen: DWORD): Longint; overload;
function ImmGetCompositionString(hImc: HIMC; dWord1: DWORD;
  lpBuf: IntPtr; dwBufLen: DWORD): Longint; overload;
function ImmGetCompositionStringA(hImc: HIMC; dWord1: DWORD;
  lpBuf: StringBuilder; dwBufLen: DWORD): Longint;
function ImmGetCompositionStringW(hImc: HIMC; dWord1: DWORD;
  lpBuf: StringBuilder; dwBufLen: DWORD): Longint;

function ImmSetCompositionString(hImc: HIMC; dwIndex: DWORD;
  lpComp: string; dwCompLen: DWORD; lpRead: string; dwReadLen: DWORD):Boolean; overload;
function ImmSetCompositionString(hImc: HIMC; dwIndex: DWORD;
  [in] lpComp: TBytes; dwCompLen: DWORD; [in] lpRead: TBytes; dwReadLen: DWORD):Boolean; overload;
function ImmSetCompositionStringA(hImc: HIMC; dwIndex: DWORD;
  lpComp: string; dwCompLen: DWORD; lpRead: string; dwReadLen: DWORD):Boolean;
function ImmSetCompositionStringW(hImc: HIMC; dwIndex: DWORD;
  lpComp: string; dwCompLen: DWORD; lpRead: string; dwReadLen: DWORD):Boolean;

function ImmGetCandidateListCount(hImc: HIMC; out ListCount: DWORD): DWORD;
function ImmGetCandidateListCountA(hImc: HIMC; out ListCount: DWORD): DWORD;
function ImmGetCandidateListCountW(hImc: HIMC; out ListCount: DWORD): DWORD;

function ImmGetCandidateList(hImc: HIMC; deIndex: DWORD;
  out lpCandidateList: TCANDIDATELIST; dwBufLen: DWORD): DWORD;
function ImmGetCandidateListA(hImc: HIMC; deIndex: DWORD;
  out lpCandidateList: TCANDIDATELIST; dwBufLen: DWORD): DWORD;
function ImmGetCandidateListW(hImc: HIMC; deIndex: DWORD;
  out lpCandidateList: TCANDIDATELIST; dwBufLen: DWORD): DWORD;

function ImmGetGuideLine(hImc: HIMC; dwIndex: DWORD;
  lpBuf: StringBuilder; dwBufLen: DWORD): DWORD;
function ImmGetGuideLineA(hImc: HIMC; dwIndex: DWORD;
  lpBuf: StringBuilder; dwBufLen: DWORD): DWORD;
function ImmGetGuideLineW(hImc: HIMC; dwIndex: DWORD;
  lpBuf: StringBuilder; dwBufLen: DWORD): DWORD;

function ImmGetConversionStatus(hImc: HIMC; out Conversion, Sentence: DWORD): Boolean;
function ImmSetConversionStatus(hImc: HIMC; Conversion, Sentence: DWORD): Boolean;
function ImmGetOpenStatus(hImc: HIMC): Boolean;
function ImmSetOpenStatus(hImc: HIMC; fOpen: Boolean): Boolean;

function ImmGetCompositionFont(hImc: HIMC; out lpLogfont: TLOGFONT): Boolean;
function ImmGetCompositionFontA(hImc: HIMC; out lpLogfont: TLOGFONTA): Boolean;
function ImmGetCompositionFontW(hImc: HIMC; out lpLogfont: TLOGFONTW): Boolean;

function ImmSetCompositionFont(hImc: HIMC; const lpLogfont: TLOGFONT): Boolean;
function ImmSetCompositionFontA(hImc: HIMC; const lpLogfont: TLOGFONTA): Boolean;
function ImmSetCompositionFontW(hImc: HIMC; const lpLogfont: TLOGFONTW): Boolean;

function ImmConfigureIME(hKl: HKL; hWnd: HWND; dwMode: DWORD;
  const lpData: TRegisterWord): Boolean; overload;
function ImmConfigureIME(hKl: HKL; hWnd: HWND; dwMode: DWORD;
  lpData: IntPtr): Boolean; overload;
function ImmConfigureIMEA(hKl: HKL; hWnd: HWND; dwMode: DWORD;
  const lpData: TRegisterWord): Boolean;
function ImmConfigureIMEW(hKl: HKL; hWnd: HWND; dwMode: DWORD;
  const lpData: TRegisterWord): Boolean;

function ImmEscape(hKl: HKL; hImc: HIMC; uEscape: UINT; lpData: IntPtr): LRESULT;
function ImmEscapeA(hKl: HKL; hImc: HIMC; uEscape: UINT; lpData: IntPtr): LRESULT;
function ImmEscapeW(hKl: HKL; hImc: HIMC; uEscape: UINT; lpData: IntPtr): LRESULT;

function ImmGetConversionList(hKl: HKL; hImc: HIMC; lpSrc: string;
  out lpDst: TCANDIDATELIST; dwBufLen: DWORD; uFlag: UINT ): DWORD;
function ImmGetConversionListA(hKl: HKL; hImc: HIMC; lpSrc: string;
  out lpDst: TCANDIDATELIST; dwBufLen: DWORD; uFlag: UINT ): DWORD;
function ImmGetConversionListW(hKl: HKL; hImc: HIMC; lpSrc: string;
  out lpDst: TCANDIDATELIST; dwBufLen: DWORD; uFlag: UINT ): DWORD; 

function ImmNotifyIME(hImc: HIMC; dwAction, dwIndex, dwValue: DWORD): Boolean;

function ImmGetStatusWindowPos(hImc: HIMC; out lpPoint : TPoint): Boolean;
function ImmSetStatusWindowPos(hImc: HIMC; const lpPoint: TPOINT): Boolean;
function ImmGetCompositionWindow(hImc: HIMC;
  out lpCompForm: TCOMPOSITIONFORM): Boolean;
function ImmSetCompositionWindow(hImc: HIMC;
  const lpCompForm: TCOMPOSITIONFORM): Boolean;
function ImmGetCandidateWindow(hImc: HIMC; dwBufLen: DWORD;
  out lpCandidate: TCANDIDATEFORM): Boolean;
function ImmSetCandidateWindow(hImc: HIMC;
  const lpCandidate: TCANDIDATEFORM): Boolean;

function ImmIsUIMessage(hWnd: HWND; msg: UINT; wParam: WPARAM; lParam: LPARAM): Boolean;
function ImmIsUIMessageA(hWnd: HWND; msg: UINT; wParam: WPARAM; lParam: LPARAM): Boolean; 
function ImmIsUIMessageW(hWnd: HWND; msg: UINT; wParam: WPARAM; lParam: LPARAM): Boolean; 

function ImmGetVirtualKey(hWnd: HWND): UINT;

type
  RegisterWordEnumProc = Function(lpReading: string; dwStyle: DWORD;
    lpszString: string; lpData: IntPtr): Integer;
  RegisterWordEnumProcA = Function(lpReading: string; dwStyle: DWORD;
    lpszString: string; lpData: IntPtr): Integer;
  RegisterWordEnumProcW = Function(lpReading: string; dwStyle: DWORD;
    lpszString: string; lpData: IntPtr): Integer;

function ImmRegisterWord(hKl: HKL; lpszReading: string; dwStyle: DWORD;
  lpszRegister: string): Boolean;
function ImmRegisterWordA(hKl: HKL; lpszReading: string; dwStyle: DWORD;
  lpszRegister: string): Boolean;
function ImmRegisterWordW(hKl: HKL; lpszReading: string; dwStyle: DWORD;
  lpszRegister: string): Boolean;

function ImmUnregisterWord(hKl: HKL; lpszReading: string; dwStyle: DWORD;
  lpszUnregister: string): Boolean;
function ImmUnregisterWordA(hKl: HKL; lpszReading: string; dwStyle: DWORD;
  lpszUnregister: string): Boolean;
function ImmUnregisterWordW(hKl: HKL; lpszReading: string; dwStyle: DWORD;
  lpszUnregister: string): Boolean;

function ImmGetRegisterWordStyle(hKl: HKL; nItem: UINT;
  out lpStyleBuf: TSTYLEBUF): UINT;
function ImmGetRegisterWordStyleA(hKl: HKL; nItem: UINT;
  out lpStyleBuf: TSTYLEBUFA): UINT;
function ImmGetRegisterWordStyleW(hKl: HKL; nItem: UINT;
  out lpStyleBuf: TSTYLEBUFW): UINT;

function ImmEnumRegisterWord(hKl: HKL; lpfnEnumProc: REGISTERWORDENUMPROC;
  lpszReading: string; dwStyle: DWORD; lpszRegister: string; lpData : IntPtr): UINT;
function ImmEnumRegisterWordA(hKl: HKL; lpfnEnumProc: REGISTERWORDENUMPROCA;
  lpszReading: string; dwStyle: DWORD; lpszRegister: string; lpData : IntPtr): UINT; 
function ImmEnumRegisterWordW(hKl: HKL; lpfnEnumProc: REGISTERWORDENUMPROCW;
  lpszReading: string; dwStyle: DWORD; lpszRegister: string; lpData : IntPtr): UINT; 

const
{ the IME related messages  ( removed in 4.0 SDK }
  WM_CONVERTREQUESTEX            = $0108;
  WM_IME_STARTCOMPOSITION        = $010D;
  WM_IME_ENDCOMPOSITION          = $010E;
  WM_IME_COMPOSITION             = $010F;
  WM_IME_KEYLAST                 = $010F;

  WM_IME_SETCONTEXT              = $0281;
  WM_IME_NOTIFY                  = $0282;
  WM_IME_CONTROL                 = $0283;
  WM_IME_COMPOSITIONFULL         = $0284;
  WM_IME_SELECT                  = $0285;
  WM_IME_CHAR                    = $0286;

  WM_IME_KEYDOWN                 = $0290;
  WM_IME_KEYUP                   = $0291;

{ wParam for WM_IME_CONTROL }
  IMC_GETCANDIDATEPOS            = $0007;
  IMC_SETCANDIDATEPOS            = $0008;
  IMC_GETCOMPOSITIONFONT         = $0009;
  IMC_SETCOMPOSITIONFONT         = $000A;
  IMC_GETCOMPOSITIONWINDOW       = $000B;
  IMC_SETCOMPOSITIONWINDOW       = $000C;
  IMC_GETSTATUSWINDOWPOS         = $000F;
  IMC_SETSTATUSWINDOWPOS         = $0010;
  IMC_CLOSESTATUSWINDOW          = $0021;
  IMC_OPENSTATUSWINDOW           = $0022;

{ wParam for WM_IME_CONTROL to the soft keyboard }
{ dwAction for ImmNotifyIME }
  NI_OPENCANDIDATE               = $0010;
  NI_CLOSECANDIDATE              = $0011;
  NI_SELECTCANDIDATESTR          = $0012;
  NI_CHANGECANDIDATELIST         = $0013;
  NI_FINALIZECONVERSIONRESULT    = $0014;
  NI_COMPOSITIONSTR              = $0015;
  NI_SETCANDIDATE_PAGESTART      = $0016;
  NI_SETCANDIDATE_PAGESIZE       = $0017;

{ lParam for WM_IME_SETCONTEXT }
  ISC_SHOWUICANDIDATEWINDOW      = $00000001;
  ISC_SHOWUICOMPOSITIONWINDOW    = $80000000;
  ISC_SHOWUIGUIDELINE            = $40000000;
  ISC_SHOWUIALLCANDIDATEWINDOW   = $0000000F;
  ISC_SHOWUIALL                  = $C000000F;

{ dwIndex for ImmNotifyIME/NI_COMPOSITIONSTR }
  CPS_COMPLETE                   = $0001;
  CPS_CONVERT                    = $0002;
  CPS_REVERT                     = $0003;
  CPS_CANCEL                     = $0004;

{ the modifiers of hot key }
  MOD_ALT                        = $0001;
  MOD_CONTROL                    = $0002;
  MOD_SHIFT                      = $0004;

  MOD_LEFT                       = $8000;
  MOD_RIGHT                      = $4000;

  MOD_ON_KEYUP                   = $0800;
  MOD_IGNORE_ALL_MODIFIER        = $0400;

{ Windows for Simplified Chinese Edition hot key ID from #10 - #2F }
  IME_CHOTKEY_IME_NONIME_TOGGLE          = $10;
  IME_CHOTKEY_SHAPE_TOGGLE               = $11;
  IME_CHOTKEY_SYMBOL_TOGGLE              = $12;

{ Windows for Japanese Edition hot key ID from #30 - #4F }
  IME_JHOTKEY_CLOSE_OPEN                 = $30;

{ Windows for Korean Edition hot key ID from #50 - #6F }
  IME_KHOTKEY_SHAPE_TOGGLE               = $50;
  IME_KHOTKEY_HANJACONVERT               = $51;
  IME_KHOTKEY_ENGLISH                    = $52;

{ Windows for Tranditional Chinese Edition hot key ID from #70 - #8F }
  IME_THOTKEY_IME_NONIME_TOGGLE          = $70;
  IME_THOTKEY_SHAPE_TOGGLE               = $71;
  IME_THOTKEY_SYMBOL_TOGGLE              = $72;

{ direct switch hot key ID from #100 - #11F }
  IME_HOTKEY_DSWITCH_FIRST               = $100;
  IME_HOTKEY_DSWITCH_LAST                = $11F;

{ IME private hot key from #200 - #21F }
  IME_HOTKEY_PRIVATE_FIRST               = $200;
  IME_ITHOTKEY_RESEND_RESULTSTR          = $200;
  IME_ITHOTKEY_PREVIOUS_COMPOSITION      = $201;
  IME_ITHOTKEY_UISTYLE_TOGGLE            = $202;
  IME_HOTKEY_PRIVATE_LAST                = $21F;

{ parameter of ImmGetCompositionString }
  GCS_COMPREADSTR                = $0001;
  GCS_COMPREADATTR               = $0002;
  GCS_COMPREADCLAUSE             = $0004;
  GCS_COMPSTR                    = $0008;
  GCS_COMPATTR                   = $0010;
  GCS_COMPCLAUSE                 = $0020;
  GCS_CURSORPOS                  = $0080;
  GCS_DELTASTART                 = $0100;
  GCS_RESULTREADSTR              = $0200;
  GCS_RESULTREADCLAUSE           = $0400;
  GCS_RESULTSTR                  = $0800;
  GCS_RESULTCLAUSE               = $1000;

{ style bit flags for WM_IME_COMPOSITION }
  CS_INSERTCHAR                  = $2000;
  CS_NOMOVECARET                 = $4000;

{ bits of fdwInit of INPUTCONTEXT }
{ IME version constants }
  IMEVER_0310                    = $0003000A;
  IMEVER_0400                    = $00040000;

{ IME property bits }
  IME_PROP_AT_CARET              = $00010000;
  IME_PROP_SPECIAL_UI            = $00020000;
  IME_PROP_CANDLIST_START_FROM_1 = $00040000;
  IME_PROP_UNICODE               = $00080000;

{ IME UICapability bits }
  UI_CAP_2700                    = $00000001;
  UI_CAP_ROT90                   = $00000002;
  UI_CAP_ROTANY                  = $00000004;

{ ImmSetCompositionString Capability bits }
  SCS_CAP_COMPSTR                = $00000001;
  SCS_CAP_MAKEREAD               = $00000002;

{ IME WM_IME_SELECT inheritance Capability bits }
  SELECT_CAP_CONVERSION          = $00000001;
  SELECT_CAP_SENTENCE            = $00000002;

{ ID for deIndex of ImmGetGuideLine }
  GGL_LEVEL                      = $00000001;
  GGL_INDEX                      = $00000002;
  GGL_STRING                     = $00000003;
  GGL_PRIVATE                    = $00000004;

{ ID for dwLevel of GUIDELINE Structure }
  GL_LEVEL_NOGUIDELINE           = $00000000;
  GL_LEVEL_FATAL                 = $00000001;
  GL_LEVEL_ERROR                 = $00000002;
  GL_LEVEL_WARNING               = $00000003;
  GL_LEVEL_INFORMATION           = $00000004;

{ ID for dwIndex of GUIDELINE Structure }
  GL_ID_UNKNOWN                  = $00000000;
  GL_ID_NOMODULE                 = $00000001;
  GL_ID_NODICTIONARY             = $00000010;
  GL_ID_CANNOTSAVE               = $00000011;
  GL_ID_NOCONVERT                = $00000020;
  GL_ID_TYPINGERROR              = $00000021;
  GL_ID_TOOMANYSTROKE            = $00000022;
  GL_ID_READINGCONFLICT          = $00000023;
  GL_ID_INPUTREADING             = $00000024;
  GL_ID_INPUTRADICAL             = $00000025;
  GL_ID_INPUTCODE                = $00000026;
  GL_ID_INPUTSYMBOL              = $00000027;
  GL_ID_CHOOSECANDIDATE          = $00000028;
  GL_ID_REVERSECONVERSION        = $00000029;
  GL_ID_PRIVATE_FIRST            = $00008000;
  GL_ID_PRIVATE_LAST             = $0000FFFF;

{ ID for dwIndex of ImmGetProperty }
  IGP_GETIMEVERSION              = 4;
  IGP_PROPERTY                   = $00000004;
  IGP_CONVERSION                 = $00000008;
  IGP_SENTENCE                   = $0000000c;
  IGP_UI                         = $00000010;
  IGP_SETCOMPSTR                 = $00000014;
  IGP_SELECT                     = $00000018;

{ dwIndex for ImmSetCompositionString API }
  SCS_SETSTR                     = (GCS_COMPREADSTR or GCS_COMPSTR);
  SCS_CHANGEATTR                 = (GCS_COMPREADATTR or GCS_COMPATTR);
  SCS_CHANGECLAUSE               = (GCS_COMPREADCLAUSE or GCS_COMPCLAUSE);

{ attribute for COMPOSITIONSTRING Structure }
  ATTR_INPUT                     = $00;
  ATTR_TARGET_CONVERTED          = $01;
  ATTR_CONVERTED                 = $02;
  ATTR_TARGET_NOTCONVERTED       = $03;
  ATTR_INPUT_ERROR               = $04;

{ bit field for IMC_SETCOMPOSITIONWINDOW, IMC_SETCANDIDATEWINDOW }
  CFS_DEFAULT                    = $0000;
  CFS_RECT                       = $0001;
  CFS_POINT                      = $0002;
  CFS_SCREEN                     = $0004;	{ removed in 4.0 SDK }
  CFS_FORCE_POSITION             = $0020;
  CFS_CANDIDATEPOS               = $0040;
  CFS_EXCLUDE                    = $0080;

{ conversion direction for ImmGetConversionList }
  GCL_CONVERSION                 = $0001;
  GCL_REVERSECONVERSION          = $0002;
  GCL_REVERSE_LENGTH             = $0003;

{ bit field for conversion mode }
  IME_CMODE_ALPHANUMERIC         = $0000;
  IME_CMODE_NATIVE               = $0001;
  IME_CMODE_CHINESE              = IME_CMODE_NATIVE;
  IME_CMODE_HANGEUL              = IME_CMODE_NATIVE;
  IME_CMODE_HANGUL               = IME_CMODE_NATIVE;
  IME_CMODE_JAPANESE             = IME_CMODE_NATIVE;
  IME_CMODE_KATAKANA             = $0002;  { effective only under IME_CMODE_NATIVE}
  IME_CMODE_LANGUAGE             = $0003;
  IME_CMODE_FULLSHAPE            = $0008;
  IME_CMODE_ROMAN                = $0010;
  IME_CMODE_CHARCODE             = $0020;
  IME_CMODE_HANJACONVERT         = $0040;
  IME_CMODE_SOFTKBD              = $0080;
  IME_CMODE_NOCONVERSION         = $0100;
  IME_CMODE_EUDC                 = $0200;
  IME_CMODE_SYMBOL               = $0400;

  IME_SMODE_NONE                 = $0000;
  IME_SMODE_PLAURALCLAUSE        = $0001;
  IME_SMODE_SINGLECONVERT        = $0002;
  IME_SMODE_AUTOMATIC            = $0004;
  IME_SMODE_PHRASEPREDICT        = $0008;

{ style of candidate }
  IME_CAND_UNKNOWN               = $0000;
  IME_CAND_READ                  = $0001;
  IME_CAND_CODE                  = $0002;
  IME_CAND_MEANING               = $0003;
  IME_CAND_RADICAL               = $0004;
  IME_CAND_STROKE                = $0005;

{ wParam of report message WM_IME_NOTIFY }
  IMN_CLOSESTATUSWINDOW          = $0001;
  IMN_OPENSTATUSWINDOW           = $0002;
  IMN_CHANGECANDIDATE            = $0003;
  IMN_CLOSECANDIDATE             = $0004;
  IMN_OPENCANDIDATE              = $0005;
  IMN_SETCONVERSIONMODE          = $0006;
  IMN_SETSENTENCEMODE            = $0007;
  IMN_SETOPENSTATUS              = $0008;
  IMN_SETCANDIDATEPOS            = $0009;
  IMN_SETCOMPOSITIONFONT         = $000A;
  IMN_SETCOMPOSITIONWINDOW       = $000B;
  IMN_SETSTATUSWINDOWPOS         = $000C;
  IMN_GUIDELINE                  = $000D;
  IMN_PRIVATE                    = $000E;

{ error code of ImmGetCompositionString }
  IMM_ERROR_NODATA               = -1;
  IMM_ERROR_GENERAL              = -2;

{ dialog mode of ImmConfigureIME }
  IME_CONFIG_GENERAL             = 1;
  IME_CONFIG_REGISTERWORD        = 2;
  IME_CONFIG_SELECTDICTIONARY    = 3;

{ dialog mode of ImmEscape }
  IME_ESC_QUERY_SUPPORT          = $0003;
  IME_ESC_RESERVED_FIRST         = $0004;
  IME_ESC_RESERVED_LAST          = $07FF;
  IME_ESC_PRIVATE_FIRST          = $0800;
  IME_ESC_PRIVATE_LAST           = $0FFF;
  IME_ESC_SEQUENCE_TO_INTERNAL   = $1001;
  IME_ESC_GET_EUDC_DICTIONARY    = $1003;
  IME_ESC_SET_EUDC_DICTIONARY    = $1004;
  IME_ESC_MAX_KEY                = $1005;
  IME_ESC_IME_NAME               = $1006;
  IME_ESC_SYNC_HOTKEY            = $1007;
  IME_ESC_HANJA_MODE             = $1008;
  IME_ESC_AUTOMATA               = $1009;

  IME_ESC_PRIVATE_HOTKEY         = $100A;

{ style of word registration }
  IME_REGWORD_STYLE_EUDC         = $00000001;
  IME_REGWORD_STYLE_USER_FIRST   = $80000000;
  IME_REGWORD_STYLE_USER_LAST    = $FFFFFFFF;

{ type of soft keyboard }
{ for Windows Tranditional Chinese Edition }
  SOFTKEYBOARD_TYPE_T1           = $0001;
{ for Windows Simplified Chinese Edition }
  SOFTKEYBOARD_TYPE_C1           = $0002;


function WINNLSEnableIME(hwnd: HWND; bool: LongBool): Boolean;

const
  imm32  = 'imm32.dll';
  user32 = 'user32.dll';

implementation

[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmInstallIME')]
function ImmInstallIME; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmInstallIMEA')]
function ImmInstallIMEA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmInstallIMEW')]
function ImmInstallIMEW; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetDefaultIMEWnd')]
function ImmGetDefaultIMEWnd; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmGetDescription')]
function ImmGetDescription; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetDescriptionA')]
function ImmGetDescriptionA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmGetDescriptionW')]
function ImmGetDescriptionW; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmGetIMEFileName')]
function ImmGetIMEFileName; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetIMEFileNameA')]
function ImmGetIMEFileNameA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmGetIMEFileNameW')]
function ImmGetIMEFileNameW; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetProperty')]
function ImmGetProperty; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmIsIME')]
function ImmIsIME; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmSimulateHotKey')]
function ImmSimulateHotKey; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmCreateContext')]
function ImmCreateContext; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmDestroyContext')]
function ImmDestroyContext; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetContext')]
function ImmGetContext; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmReleaseContext')]
function ImmReleaseContext; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmAssociateContext')]
function ImmAssociateContext; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmGetCompositionString')]
function ImmGetCompositionString(hImc: HIMC; dWord1: DWORD;
  lpBuf: StringBuilder; dwBufLen: DWORD): Longint; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmGetCompositionString')]
function ImmGetCompositionString(hImc: HIMC; dWord1: DWORD;
  [out] lpBuf: TBytes; dwBufLen: DWORD): Longint; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmGetCompositionString')]
function ImmGetCompositionString(hImc: HIMC; dWord1: DWORD;
  lpBuf: IntPtr; dwBufLen: DWORD): Longint; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetCompositionStringA')]
function ImmGetCompositionStringA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmGetCompositionStringW')]
function ImmGetCompositionStringW; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmSetCompositionString')]
function ImmSetCompositionString(hImc: HIMC; dwIndex: DWORD;
  lpComp: string; dwCompLen: DWORD; lpRead: string; dwReadLen: DWORD):Boolean; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmSetCompositionString')]
function ImmSetCompositionString(hImc: HIMC; dwIndex: DWORD;
  [in] lpComp: TBytes; dwCompLen: DWORD; [in] lpRead: TBytes; dwReadLen: DWORD):Boolean; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmSetCompositionStringA')]
function ImmSetCompositionStringA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmSetCompositionStringW')]
function ImmSetCompositionStringW; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmGetCandidateListCount')]
function ImmGetCandidateListCount; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetCandidateListCountA')]
function ImmGetCandidateListCountA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmGetCandidateListCountW')]
function ImmGetCandidateListCountW; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmGetCandidateList')]
function ImmGetCandidateList; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetCandidateListA')]
function ImmGetCandidateListA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmGetCandidateListW')]
function ImmGetCandidateListW; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmGetGuideLine')]
function ImmGetGuideLine; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetGuideLineA')]
function ImmGetGuideLineA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmGetGuideLineW')]
function ImmGetGuideLineW; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetConversionStatus')]
function ImmGetConversionStatus; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmSetConversionStatus')]
function ImmSetConversionStatus; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetOpenStatus')]
function ImmGetOpenStatus; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmSetOpenStatus')]
function ImmSetOpenStatus; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmGetCompositionFont')]
function ImmGetCompositionFont; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetCompositionFontA')]
function ImmGetCompositionFontA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmGetCompositionFontW')]
function ImmGetCompositionFontW; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmSetCompositionFont')]
function ImmSetCompositionFont; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmSetCompositionFontA')]
function ImmSetCompositionFontA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmSetCompositionFontW')]
function ImmSetCompositionFontW; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmConfigureIME')]
function ImmConfigureIME(hKl: HKL; hWnd: HWND; dwMode: DWORD;
  const lpData: TRegisterWord): Boolean; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmConfigureIME')]
function ImmConfigureIME(hKl: HKL; hWnd: HWND; dwMode: DWORD;
  lpData: IntPtr): Boolean; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmConfigureIMEA')]
function ImmConfigureIMEA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmConfigureIMEW')]
function ImmConfigureIMEW; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmEscape')]
function ImmEscape; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmEscapeA')]
function ImmEscapeA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmEscapeW')]
function ImmEscapeW; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmGetConversionList')]
function ImmGetConversionList; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetConversionListA')]
function ImmGetConversionListA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmGetConversionListW')]
function ImmGetConversionListW; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmNotifyIME')]
function ImmNotifyIME; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetStatusWindowPos')]
function ImmGetStatusWindowPos; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmSetStatusWindowPos')]
function ImmSetStatusWindowPos; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetCompositionWindow')]
function ImmGetCompositionWindow; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmSetCompositionWindow')]
function ImmSetCompositionWindow; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetCandidateWindow')]
function ImmGetCandidateWindow; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmSetCandidateWindow')]
function ImmSetCandidateWindow; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmIsUIMessage')]
function ImmIsUIMessage; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmIsUIMessageA')]
function ImmIsUIMessageA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmIsUIMessageW')]
function ImmIsUIMessageW; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetVirtualKey')]
function ImmGetVirtualKey; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmRegisterWord')]
function ImmRegisterWord; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmRegisterWordA')]
function ImmRegisterWordA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmRegisterWordW')]
function ImmRegisterWordW; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmUnregisterWord')]
function ImmUnregisterWord; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmUnregisterWordA')]
function ImmUnregisterWordA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmUnregisterWordW')]
function ImmUnregisterWordW; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmGetRegisterWordStyle')]
function ImmGetRegisterWordStyle; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmGetRegisterWordStyleA')]
function ImmGetRegisterWordStyleA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmGetRegisterWordStyleW')]
function ImmGetRegisterWordStyleW; external;
[DllImport(imm32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ImmEnumRegisterWord')]
function ImmEnumRegisterWord; external;
[DllImport(imm32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImmEnumRegisterWordA')]
function ImmEnumRegisterWordA; external;
[DllImport(imm32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ImmEnumRegisterWordW')]
function ImmEnumRegisterWordW; external;

[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WINNLSEnableIME')]
function WINNLSEnableIME; external;

end.

